/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.world;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.init.ModBlockEntities;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.S2C_SetTrackedStashPacket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;

public class LootStashes {
    private static final ForkJoinPool ASYNC_POOL = new ForkJoinPool(2);
    private static final Set<UUID> TRACKING = Collections.synchronizedSet(new HashSet());
    private static Set<BlockPos> cache = Collections.emptySet();
    private static int updateScheduler;

    public static void addTracker(ServerPlayerEntity player) {
        TRACKING.add(player.func_110124_au());
        LootStashes.updateClosestAsync((PlayerEntity)player);
    }

    public static void clearTracker(UUID uuid) {
        TRACKING.remove(uuid);
    }

    public static void initiateImmediateRefresh() {
        updateScheduler = 0;
    }

    public static void tick(ServerWorld world) {
        if (TRACKING.isEmpty()) {
            return;
        }
        if (--updateScheduler <= 0) {
            updateScheduler = GunsRPG.config.world.lootStashUpdateInterval;
            LootStashes.initiateRefreshAsync(world);
        }
    }

    private static void initiateRefreshAsync(ServerWorld world) {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> LootStashes.getLoaded(world), ASYNC_POOL).exceptionally(err -> {
            GunsRPG.log.error("Couldn't refresh loot stashes, error occurred: {}", (Object)err.toString());
            return Collections.emptySet();
        })).thenAccept(set -> {
            cache = set;
            Iterator<UUID> iterator = TRACKING.iterator();
            while (iterator.hasNext()) {
                UUID uuid = iterator.next();
                PlayerEntity player = world.func_217371_b(uuid);
                if (player == null) {
                    iterator.remove();
                    continue;
                }
                LootStashes.updateClosestAsync(player);
            }
        });
    }

    private static void updateClosestAsync(PlayerEntity player) {
        CompletableFuture.supplyAsync(() -> {
            if (cache.isEmpty()) {
                return null;
            }
            BlockPos closest = null;
            double dist = Double.MAX_VALUE;
            for (BlockPos pos : cache) {
                double blockDist = LootStashes.getDistanceTo(pos, (Entity)player);
                if (!(blockDist < dist)) continue;
                closest = pos;
                dist = blockDist;
            }
            return closest;
        }, ASYNC_POOL).thenAccept(pos -> {
            if (pos != null) {
                NetworkManager.sendClientPacket((ServerPlayerEntity)player, new S2C_SetTrackedStashPacket((BlockPos)pos));
            } else {
                NetworkManager.sendClientPacket((ServerPlayerEntity)player, new S2C_SetTrackedStashPacket());
            }
        });
    }

    private static Set<BlockPos> getLoaded(ServerWorld world) {
        ChunkManager manager = world.func_72863_F().field_217237_a;
        Iterable iterable = manager.func_223491_f();
        return StreamSupport.stream(iterable.spliterator(), true).filter(holder -> holder.func_219298_c() != null).map(holder -> {
            Chunk chunk = holder.func_219298_c();
            HashSet positions = new HashSet();
            for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                TileEntity entity = (TileEntity)entry.getValue();
                if (entity.func_200662_C() != ModBlockEntities.MILITARY_CRATE.get()) continue;
                positions.add(entry.getKey());
            }
            return positions;
        }).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static double getDistanceTo(BlockPos pos, Entity entity) {
        double x = Math.abs((double)pos.func_177958_n() - entity.func_226277_ct_());
        double z = Math.abs((double)pos.func_177952_p() - entity.func_226281_cx_());
        return x * x + z * z;
    }
}

